/*
 * Decompiled with CFR 0.152.
 */
package itx.erp.sales.model;

import itx.erp.customer.model.Customer;
import itx.erp.sales.model.OrderLine;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import jtbcore.model.BaseStringMap;
import jtbcore.model.BaseStringMapObject;

public class Order
implements BaseStringMapObject {
    protected BaseStringMap bsm = new BaseStringMap();
    protected List<OrderLine> lines = new ArrayList<OrderLine>();
    protected Customer customer = null;

    public Order() {
        this.setCreditOrder(false);
        this.setTaxShift(false);
    }

    public List<OrderLine> getLines() {
        return this.lines;
    }

    public void setLines(List<OrderLine> lines) {
        this.lines = lines;
    }

    public void setCustomer(Customer c) {
        this.customer = c;
        if (c != null) {
            this.setCustomerId(c.getCustomerId());
        }
    }

    public Customer getCustomer() {
        return this.customer;
    }

    public String getCustomerName() {
        if (this.customer != null) {
            return this.customer.getCustomerName();
        }
        if (this.bsm.hasProperty("customer_name")) {
            return this.bsm.getProperty("customer_name");
        }
        return null;
    }

    public Integer getOrderId() {
        return this.bsm.getPropertyInt("order_id");
    }

    public void setOrderId(Integer i) {
        this.bsm.setProperty("order_id", i);
    }

    public Integer getCustomerId() {
        return this.bsm.getPropertyInt("customer_id");
    }

    public void setCustomerId(Integer i) {
        this.bsm.setProperty("customer_id", i);
    }

    public Date getOrderDate() {
        return this.bsm.getPropertyDate("order_date");
    }

    public void setOrderDate(Date d) {
        this.bsm.setProperty("order_date", d);
    }

    public String getOrderStatus() {
        return this.bsm.getProperty("order_status");
    }

    public void setOrderStatus(String s) {
        this.bsm.setProperty("order_status", s);
    }

    public Integer getRefOrderId() {
        return this.bsm.getPropertyInt("ref_order_id");
    }

    public void setRefOrderId(Integer i) {
        this.bsm.setProperty("ref_order_id", i);
    }

    public Boolean getCreditOrder() {
        return this.bsm.getPropertyBool("credit_order");
    }

    public void setCreditOrder(Boolean b) {
        this.bsm.setProperty("credit_order", b);
    }

    public Boolean getTaxShift() {
        return this.bsm.getPropertyBool("tax_shift");
    }

    public void setTaxShift(Boolean b) {
        this.bsm.setProperty("tax_shift", b);
    }

    public Integer getOrderNumber() {
        return this.bsm.getPropertyInt("order_number");
    }

    public void setOrderNumber(Integer i) {
        this.bsm.setProperty("order_number", i);
    }

    public String getSubject() {
        return this.bsm.getProperty("subject");
    }

    public void setSubject(String s) {
        this.bsm.setProperty("subject", s);
    }

    public String getComment() {
        return this.bsm.getProperty("comment");
    }

    public void setComment(String s) {
        this.bsm.setProperty("comment", s);
    }

    public String getInternalNote() {
        return this.bsm.getProperty("internal_note");
    }

    public void setInternalNote(String s) {
        this.bsm.setProperty("internal_note", s);
    }

    public Double getTotalCalculatedPrice() {
        return this.bsm.getPropertyDouble("total_calculated_price");
    }

    public void setTotalCalculatedPrice(Double p) {
        this.bsm.setProperty("total_calculated_price", p);
    }

    public Double getTotalCalculatedPriceInclVat() {
        return this.bsm.getPropertyDouble("total_calculated_price_incl_vat");
    }

    public void setTotalCalculatedPriceInclVat(Double p) {
        this.bsm.setProperty("total_calculated_price_incl_vat", p);
    }

    public Date getEdited() {
        return this.bsm.getPropertyDate("edited");
    }

    public void setEdited(Date d) {
        this.bsm.setProperty("edited", d);
    }

    public Date getCreated() {
        return this.bsm.getPropertyDate("created");
    }

    public void setCreated(Date d) {
        this.bsm.setProperty("created", d);
    }

    public Map<Double, Double> getVatTotals() {
        HashMap<Integer, Double> ts = new HashMap<Integer, Double>();
        int x = 0;
        while (x < this.getLines().size()) {
            OrderLine ol = this.getLines().get(x);
            if (!"text".equals(ol.getLineType())) {
                Integer vatP = 0;
                if (ol.getVatPercentage() != null) {
                    vatP = (int)(ol.getVatPercentage() * 100.0);
                }
                if (!ts.containsKey(vatP)) {
                    ts.put(vatP, 0.0);
                }
                if (ol.getVatAmountSingleItem() != null && ol.getAmount() != null) {
                    Double t = (Double)ts.get(vatP);
                    t = t + ol.getVatAmountSingleItem() * ol.getAmount();
                    ts.put(vatP, t);
                }
            }
            ++x;
        }
        ArrayList keys = new ArrayList(ts.keySet());
        keys.sort(new Comparator<Integer>(){

            @Override
            public int compare(Integer o1, Integer o2) {
                return o1 - o2;
            }
        });
        LinkedHashMap<Double, Double> result = new LinkedHashMap<Double, Double>();
        for (Integer k : keys) {
            Double vp = (double)k.intValue() / 100.0;
            result.put(vp, (Double)ts.get(k));
        }
        return result;
    }

    @Override
    public BaseStringMap getBaseStringMap() {
        return this.bsm;
    }

    @Override
    public void setBaseStringMap(BaseStringMap bsm) {
        this.bsm = bsm;
    }
}

